package com.agilex.healthcare.veteranappointment.config;


import org.apache.commons.logging.Log;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import java.util.Set;
import com.agilex.healthcare.veteranappointment.domain.VeteranAppointmentConfiguration;
import com.agilex.healthcare.veteranappointment.dataservice.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
/**
 * Class to validate the veteran appointment configurations.
 */
public class VeteranAppointmentConfigurationValidator{
    private static final Log logger = org.apache.commons.logging.LogFactory.getLog(VeteranAppointmentConfigurationValidator.class);

    public VeteranAppointmentConfigurationValidator(ConfigurationService configurationService){
      logger.info("ENTER VeteranAppointmentConfigurationValidator ...");
        //Getting Validator instance with Annotations
        ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
        Validator validator = validatorFactory.getValidator();
        VeteranAppointmentConfiguration config = configurationService.getConfigurations();
        logger.info("Value for numberOfMonthsForFutureAppointments="+config.getNumberOfMonthsForFutureAppointments());
        Set<ConstraintViolation<VeteranAppointmentConfiguration>> constraintViolations =
                validator.validate( config );
        if(constraintViolations!=null && constraintViolations.isEmpty() == false){
            logger.error("Invalid value:"+config.getNumberOfMonthsForFutureAppointments()+", throwing exception");
            for(ConstraintViolation violation: constraintViolations){
                logger.error("Violation::"+violation.getMessage());
            }
            throw new IllegalArgumentException("numberOfMonthsForFutureAppointments is invalid");
        }
    }





}
